import React, { FC } from 'react';

type TrashProps = {
  width?: number;
  height?: number;
  className?: string;
};

const Trash: FC<TrashProps> = ({ width, height, className }) => {
  return (
    <svg
      width={width}
      height={height}
      className={className}
      fill="currentColor"
      viewBox="0 0 1792 1792"
    >
      <path d="M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"></path>
    </svg>
  );
};

export default Trash;

export const TrashTwo: FC<TrashProps> = ({ width, height, className }) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width={width}
      height={height}
      className={className}
    >
      <path
        fill="currentColor"
        d="M16.125 6a.875.875 0 0 0-.875.875v9.791a1.68 1.68 0 0 1-1.759 1.583H6.51a1.68 1.68 0 0 1-1.759-1.583V6.875a.875.875 0 0 0-1.75 0v9.791A3.428 3.428 0 0 0 6.509 20h6.982A3.428 3.428 0 0 0 17 16.666V6.875A.875.875 0 0 0 16.125 6ZM17.111 3h-3.555V1c0-.265-.094-.52-.26-.707a.842.842 0 0 0-.63-.293H7.334a.842.842 0 0 0-.628.293c-.167.187-.26.442-.26.707v2H2.888a.842.842 0 0 0-.629.293C2.094 3.48 2 3.735 2 4c0 .265.094.52.26.707A.842.842 0 0 0 2.89 5H17.11a.842.842 0 0 0 .629-.293c.166-.187.26-.442.26-.707 0-.265-.094-.52-.26-.707A.842.842 0 0 0 17.11 3ZM8.222 3V2h3.556v1H8.222Z"
      />
      <path
        fill="currentColor"
        d="M9 14.111V7.89a.842.842 0 0 0-.293-.629A1.067 1.067 0 0 0 8 7c-.265 0-.52.094-.707.26A.842.842 0 0 0 7 7.89v6.222c0 .236.105.462.293.629.187.166.442.26.707.26.265 0 .52-.094.707-.26A.842.842 0 0 0 9 14.11ZM13 14.111V7.89a.842.842 0 0 0-.293-.629A1.067 1.067 0 0 0 12 7c-.265 0-.52.094-.707.26A.842.842 0 0 0 11 7.89v6.222c0 .236.105.462.293.629.187.166.442.26.707.26.265 0 .52-.094.707-.26A.842.842 0 0 0 13 14.11Z"
      />
    </svg>
  );
};
