import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gshop/app_constants.dart';
import 'package:gshop/infrastructure/model/response/banners_paginate_response.dart';
import 'package:gshop/infrastructure/service/services.dart';
import 'package:gshop/presentation/components/components.dart';
import 'package:gshop/presentation/route/app_route.dart';
import 'package:gshop/presentation/style/style.dart';
import 'package:gshop/presentation/style/theme/theme.dart';

class BannerBottomSheet extends StatelessWidget {
  final BannerData banner;
  final CustomColorSet colors;

  const BannerBottomSheet(
      {Key? key, required this.banner, required this.colors})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return BlurWrap(
      radius: BorderRadius.only(
        topRight: Radius.circular(AppConstants.radiusMax.r),
        topLeft: Radius.circular(AppConstants.radiusMax.r),
      ),
      child: Container(
        decoration: BoxDecoration(
          color: colors.newBoxColor,
          borderRadius: BorderRadius.only(
            topRight: Radius.circular(AppConstants.radiusMax.r),
            topLeft: Radius.circular(AppConstants.radiusMax.r),
          ),
        ),
        padding: EdgeInsets.all(16.r),
        child: SingleChildScrollView(
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              CustomNetworkImage(
                  url: banner.galleries?.first.path,
                  preview: banner.galleries?.first.preview,
                  height: 180,
                  width: double.infinity,
                  radius: 24),
              16.verticalSpace,
              Text(
                banner.translation?.description ?? "",
                style: CustomStyle.interNormal(
                  color: colors.textBlack,
                  size: 18,
                ),
              ),
              16.verticalSpace,
              Text(
                banner.translation?.description ?? "",
                style: CustomStyle.interRegular(
                  color: colors.textBlack,
                  size: 16,
                ),
              ),
              24.verticalSpace,
              CustomButton(
                  title: AppHelpers.getTranslation(TrKeys.viewProducts),
                  bgColor: CustomStyle.black,
                  titleColor: CustomStyle.white,
                  onTap: () {
                    AppRoute.goProductList(
                        context: context,
                        title: banner.translation?.description ?? "",
                        bannerId: banner.id);
                  }),
              16.verticalSpace,
            ],
          ),
        ),
      ),
    );
  }
}
