import 'package:gshop/infrastructure/local_storage/local_storage.dart';

class FilterModel {
  final String type;
  final List<int>? shopId;
  final List<int>? brandId;
  final List<int>? categoryId;
  final List<int>? extrasId;
  final num? priceTo;
  final num? priceFrom;
  final int? parentId;

  FilterModel(
      {required this.type,
       this.shopId,
       this.brandId,
       this.categoryId,
       this.extrasId,
       this.priceTo,
       this.priceFrom,
       this.parentId});

  factory FilterModel.fromJson(
      {required String type,
      required List<int>? shopId,
      required List<int>? brandId,
      required List<int>? categoryId,
      required List<int>? extrasId,
      required num priceTo,
      required num priceFrom,
      required int parentId}) {
    return FilterModel(
        type: type,
        shopId: shopId,
        brandId: brandId,
        categoryId: categoryId,
        extrasId: extrasId,
        priceTo: priceTo,
        priceFrom: priceFrom,
        parentId: parentId);
  }

  Map<String, dynamic> toJson() {
    List listOfCategory = [];
    listOfCategory.addAll(categoryId ?? []);
    if (parentId != null) {
      listOfCategory.add(parentId);
    }
    return {
      for (int i = 0; i < listOfCategory.length; i++)
        'category_ids[$i]': listOfCategory[i],
      if (brandId != null)
        for (int i = 0; i < (brandId?.length ?? 0); i++)
          'brand_ids[$i]': brandId?[i],
      if (shopId != null)
        for (int i = 0; i < (shopId?.length ?? 0); i++)
          'shop_ids[$i]': shopId?[i],
      if (extrasId != null)
        for (int i = 0; i < (extrasId?.length ?? 0); i++)
          'extras[$i]': extrasId?[i],
      if (priceTo != null) "price_to": priceTo,
      if (priceFrom != null) 'price_from': priceFrom,
      'currency_id': LocalStorage.getSelectedCurrency()?.id,
      'lang': LocalStorage.getLanguage()?.locale,
      'type': type,
      if (LocalStorage.getAddress()?.regionId != null)
        "region_id": LocalStorage.getAddress()?.regionId,
      if (LocalStorage.getAddress()?.countryId != null)
        'country_id': LocalStorage.getAddress()?.countryId,
      if (LocalStorage.getAddress()?.cityId != null)
        'city_id': LocalStorage.getAddress()?.cityId,
    };
  }
}
