<?php

use App\Models\RequestModel;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRequestModelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
	{
        Schema::create('request_models', function (Blueprint $table) {
            $table->id();
			$table->nullableMorphs('model');
			$table->foreignId('created_by')->nullable()->constrained('users')->cascadeOnUpdate()->cascadeOnDelete();
			$table->jsonb('data')->nullable();
            $table->string('status')->default(RequestModel::STATUS_PENDING);
            $table->string('status_note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
	{
        Schema::dropIfExists('request_models');
    }
}
